<?php
  function getCounter()
  {
    if(!file_exists("./licznik.txt")){
      //brak pliku licznika
      return false;
    }
    if(!$fd = fopen("./licznik.txt", "r+")){
      //brak dostępu do pliku licznika
      return false;
    }
    flock($fd, LOCK_EX);
    $count = trim(fgets($fd));
    if(is_numeric($count)){
      $count = $count + 1;
      $data = fgets($fd);
      fseek($fd, 0);
      fputs($fd, $count."\n");
      fputs($fd, $data);
      $result = array($count, $data);
    }
    else{
      //nieprawidłowy format odczytanych danych
      $result = false;
    }
    flock($fd, LOCK_UN);
    fclose($fd);
    return $result;
  }
  function getCounterStr()
  {
    if(($dane = getCounter()) !== false){
      if(($count = $dane[0]) == 1){
        $razy = 'raz';
      }
      else{
        $razy = 'razy';
      }
      return "Ta strona została odwiedzona $count $razy " .
             "od {$dane[1]} roku.";
    }
    else{
      return "Licznik odwołań jest czasowo niedostępny.";
    }
  }
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Moja strona WWW</title>
  </head>
  <body>
    <p>
    <?php
      echo getCounterStr();
    ?>
    </p>
  </body>
</html>
